#ifndef HARDWARE_H
#define HARDWARE_H

#include <io.h>
#include <signal.h>
#include <iomacros.h>

/* Pinbelegung */
/* Pin1:  VCC
   Pin2:  P1.0 Input, int. Pullup, linke Taste
   Pin3:  P1.1 Input, int. Pullup, rechte Taste
   Pin4:  P1.2 Input, int. Pullup, NC
   Pin5:  P1.3 Input, int. Pullup, NC
   Pin6:  P1.4 Input, int. Pullup, NC
   Pin7:  P1.5 Output, TA0, Ultraschallsignal zum Mischer
   
   Pin8:  P1.6 Input, int. Pullup, NC
   Pin9:  P1.7 Input, int. Pullup, NC
   Pin10: RESET
   Pin11: TEST
   Pin12: P2.7 Output, FREQANZ
   Pin13: P2.6 Input, int. Pullup, NC
   Pin14: GND */

//Port Output Register 'P1OUT, P2OUT':
#define P1OUT_INIT      0xFF                       // Init Output data of port1
#define P2OUT_INIT      0xFF                       // Init Output data of port2

//Port Direction Register 'P1DIR, P2DIR':
#define P1DIR_INIT      0x20                    // Init of Port1 Data-Direction Reg (Out=1 / Inp=0)
#define P2DIR_INIT      0x80                    // Init of Port2 Data-Direction Reg (Out=1 / Inp=0)

//Selection of Port or Module -Function on the Pins 'P1SEL, P2SEL'
#define P1SEL_INIT      0x20                    // P1-Modules:
#define P2SEL_INIT      0x00                    // P2-Modules

#define P1REN_INIT      0xDF
#define P2REN_INIT	0x7F

//Interrupt capabilities of P1 and P2
#define P1IE_INIT       0x00                    // Interrupt Enable (0=dis 1=enabled)
#define P2IE_INIT       0                       // Interrupt Enable (0=dis 1=enabled)
#define P1IES_INIT      0x00                    // Interrupt Edge Select (0=pos 1=neg)
#define P2IES_INIT      0                       // Interrupt Edge Select (0=pos 1=neg)

#define WDTCTL_INIT     WDTPW|WDTHOLD

#define FREQANZ_PORT    0x80
#define FREQANZ_TOGGLE  P2OUT ^= FREQANZ_PORT
#define FREQANZ_AN      P2OUT |= FREQANZ_PORT
#define FREQANZ_AUS     P2OUT &= ~FREQANZ_PORT
#define TASTE1 0x01
#define TASTE2 0x02
#define TASTE3 0x04
#define ALLETASTEN 0x07
#define TASTE1_GEDRUECKT ((P1IN & TASTE1) == 0)
#define TASTE2_GEDRUECKT ((P1IN & TASTE2) == 0)
#define TASTE3_GEDRUECKT ((P1IN & TASTE3) == 0)
#define TASTE_GEDRUECKT ((P1IN & ALLETASTEN) != ALLETASTEN)
#define TASTE_WERT (P1IN & ALLETASTEN)
#endif //HARDWARE_H
