#ifndef HARDWARE_H
#define HARDWARE_H

#include <io.h>
#include <signal.h>
#include <iomacros.h>

/* Pinbelegung */
/* Pin1:  VCC MSP430F20x1
   Pin2:  P1.0/TACLK/ACLK/CA0:    Input NIRQ, active Low
   Pin3:  P1.1/TA0/CA1:           Input MSI, Daten vom RFM12
   Pin4:  P1.2/TA1/CA2:           Output MSO, Daten an RFM12
   Pin5:  P1.3/CAOUT/CA3:         Output SCL, Clock
   Pin6:  P1.4/SMCLK/CA4/TCK:     Output CS, active LOW
   Pin7:  P1.5/TA0/CA5/TMS:       NC
   
   Pin8:  P1.6/TA1/CA6/TDI/TCLK:  Output, NC
   Pin9:  P1.7/CAOUT/CA7/TDO/TDI: Output, NC
   Pin10: RESET/NMI/SBWTDIO
   Pin11: TEST/SBWTCK
   Pin12: P2.7/XOUT:              Output LED, active HIGH
   Pin13: P2.6/XIN/TA1:           NC
   Pin14: GND */

//Port Output Register 'P1OUT, P2OUT':
#define P1OUT_INIT      0x00                      // Init Output data of port1
#define P2OUT_INIT      0x00                      // Init Output data of port2

//Port Direction Register 'P1DIR, P2DIR':
#define P1DIR_INIT      0xFC                   // Init of Port1 Data-Direction Reg (Out=1 / Inp=0)
#define P2DIR_INIT      0xC0                    // Init of Port2 Data-Direction Reg (Out=1 / Inp=0)

//Selection of Port or Module -Function on the Pins 'P1SEL, P2SEL'
#define P1SEL_INIT      0x00                    // P1-Modules:
#define P2SEL_INIT      0x00                    // P2-Modules

#define P1REN_INIT      0x00
#define P2REN_INIT      0x00

//Interrupt capabilities of P1 and P2
#define P1IE_INIT       0x00                    // Interrupt Enable (0=dis 1=enabled)
#define P2IE_INIT       0                       // Interrupt Enable (0=dis 1=enabled)
#define P1IES_INIT      0x00                    // Interrupt Edge Select (0=pos 1=neg)
#define P2IES_INIT      0                       // Interrupt Edge Select (0=pos 1=neg)

#define WDTCTL_INIT     WDTPW|WDTHOLD

#define CS_PORT 0x10
#define MSO_PORT 0x04
#define SCL_PORT 0x08
#define MSI_PORT 0x02
#define INT_PORT 0x01
#define LED_PORT 0x80

#define CS_LOW P1OUT = P1OUT & ~CS_PORT
#define CS_HIGH P1OUT = P1OUT | CS_PORT
#define MSO_LOW P1OUT = P1OUT & ~MSO_PORT
#define MSO_HIGH P1OUT = P1OUT | MSO_PORT
#define SCL_LOW P1OUT = P1OUT & ~SCL_PORT
#define SCL_HIGH P1OUT = P1OUT | SCL_PORT

#define MSI_IS_HIGH ((P1IN & MSI_PORT) == (MSI_PORT))
#define INT_IS_HIGH ((P1IN & INT_PORT) == (INT_PORT))

#define TOGGLE_LED P2OUT = P2OUT ^ LED_PORT

#endif //HARDWARE_H
