#include "hardware.h"
#include <signal.h>

#define SYSFREQ 8000000l /* Systemtakt in Hz */

#define FREQPWM 100l     /* Taktfrequenz fuer PWM und TA1 interrupt */
#define PERIODEPWM (SYSFREQ / FREQPWM / 16) /* Wert fuer Timer um FREQPWM zu erreichen */
#define STARTBURST 4
#define SENDEPERIODE 59

#define CONFIG_COMMAND           0x8000
#define CONFIG_RESET             0x8008
#define ENABLE_INTERNAL_DATAREG  0x0080
#define ENABLE_FIFO              0x0040
#define FREQ_315MHZ              0x0000
#define FREQ_433MHZ              0x0010
#define FREQ_868MHZ              0x0020
#define FREQ_915MHZ              0x0030
#define DEFAULT_CONFIG_VAL       (CONFIG_COMMAND|ENABLE_FIFO|FREQ_433MHZ|CRYSTAL_CAPACITY_PF(12.5))


#define POWER_MAN_COMMAND        0x8200
#define POWER_MAN_RESET          0x8208
#define ENABLE_WHOLE_RX          0x0080
#define ENABLE_BASEBAND          0x0040
#define ENABLE_TX                0x0020
#define ENABLE_SYNTHESIZER       0x0010
#define ENABLE_CRYSTAL           0x0008
#define ENABLE_BATTERIE_DETECT   0x0004
#define ENABLE_WAKE_UP_TIMER     0x0002
#define DISABLE_CLOCK_PIN        0x0001
//#define DEFAULT_POWER_MAN_VAL    (POWER_MAN_COMMAND|ENABLE_BASEBAND|ENABLE_SYNTHESIZER|ENABLE_CRYSTAL)
#define DEFAULT_POWER_MAN_VAL    (POWER_MAN_COMMAND | ENABLE_TX | ENABLE_SYNTHESIZER | ENABLE_CRYSTAL | DISABLE_CLOCK_PIN)


#define FREQUENCY_COMMAND        0xA000
#define FREQUENCY_RESET          0xA680
#define FUNKFREQUENZ            433.92  /* MHz */

#define BAUD_RATE_COMMAND        0xC600
#define BAUD_RATE_RESET          0xC623

#define RECEIVER_CONTROL_COMMAND 0x9000
#define RECEIVER_CONTROL_RESET   0x9080
#define VDI_OUTPUT               0x0400
#define VDI_FAST                 0x0000
#define VDI_MEDIUM               0x0100
#define VDI_SLOW                 0x0200
#define VDI_ALWAYS_ON            0x0300
#define RX_BANDWIDTH_400_KHZ     0x0020
#define RX_BANDWIDTH_340_KHZ     0x0040
#define RX_BANDWIDTH_270_KHZ     0x0060
#define RX_BANDWIDTH_200_KHZ     0x0080
#define RX_BANDWIDTH_134_KHZ     0x00A0
#define RX_BANDWIDTH_67_KHZ      0x00C0
#define LNA_MINUS_0_DB           0x0000
#define LNA_MINUS_6_DB           0x0008
#define LNA_MINUS_14_DB          0x0010
#define LNA_MINUS_20_DB          0x0018
//#define DEFAULT_RECEIVER_CONTROL_VAL (RECEIVER_CONTROL_COMMAND|VDI_OUTPUT|VDI_FAST|RX_BANDWIDTH_400_KHZ|LNA_MINUS_20_DB|RSSI_DBM(-103))
#define DEFAULT_RECEIVER_CONTROL_VAL (RECEIVER_CONTROL_COMMAND|VDI_OUTPUT|VDI_FAST|RX_BANDWIDTH_134_KHZ|LNA_MINUS_0_DB|RSSI_DBM(-103))


#define DATA_FILTER_COMMAND      0xC228
#define DATA_FILTER_RESET        0xC22C
#define CLOCK_RECOVERY_AUTO      0x0080
#define CLOCK_RECOVERY_FAST      0x0040
#define ANALOG_FILTER            0x0010

#define FIFO_COMMAND             0xCA00
#define FIFO_RESET               0xCA80
#define ONE_SYNC_BYTE            0x0008
#define ALWAYS_FILL              0x0004
#define ENABLE_SYNC_PATTERN      0x0002
#define DISABLE_SENSITIVE_RST    0x0001
#define DEFAULT_FIFO_VAL         (FIFO_COMMAND|DISABLE_SENSITIVE_RST|FIFO_SIZE(8))

#define SYNC_PATTERN_COMMAND     0xCE00
#define SYNC_PATTERN_RESET       0xCED4

#define FIFO_READ_COMMAND        0xB000

#define AFC_COMMAND              0xC400
#define AFC_RESET                0xC4F7
#define AFC_ENABLE               0x0001
#define AFC_OFFSET_ENABLE        0x0002
#define AFC_FINE_MODE            0x0004
#define AFC_STROBE               0x0008
#define AFC_NO_LIMIT             0x0000
#define AFC_40KHZ_AT_433MHZ      0x0010
#define AFC_20KHZ_AT_433MHZ      0x0020
#define AFC_10KHZ_AT_433MHZ      0x0030
#define AFC_80KHZ_AT_868MHZ      0x0010
#define AFC_40KHZ_AT_868MHZ      0x0020
#define AFC_20KHZ_AT_868MHZ      0x0030
#define AFC_AUTO_OFF             0x0000
#define AFC_1_AFTER_POR          0x0040
#define AFC_IF_VDI               0x0080
#define AFC_AUTO                 0x00C0

#define TRANSMITTER_CONTROL_COMMAND 0x9800
#define TRANSMITTER_CONTROL_RESET   0x9800
#define INVERTED                    0x0100

#define PLL_COMMAND                 0xCC02
#define PLL_RESET                   0xCC67
#define CLK_3_3MHZ                  0x0060
#define LOW_POWER_MODE              0x0010
#define DELAY_ON                    0x0008
#define DISABLE_DITHERING           0x0004
#define PLL_BANDWITH_256KBAUD       0x0001

#define TRANSMITTER_WRITE_COMMAND   0xB800
#define TRANSMITTER_WRITE_RESET     0xB8AA

#define WAKEUP_RESET                0xE196
#define DEFAULT_WAKEUP              0xE000
#define LOW_DUTY_CYCLE_RESET        0xC80E
#define DEFAULT_LOW_DUTY_CYCLE      0xC800

#define STATUS_COMMAND              0x0000
#define FIFO_FULL_BIT               0x8000
#define TX_READY_BIT                FIFO_FULL_BIT
#define TRANSMISSION_END_BIT        FIFO_FULL_BIT
#define POR_BIT                     0x4000
#define FIFO_OVER_FLOW_BIT          0x2000
#define TX_UNDER_RUN                FIFO_OVER_FLOW_BIT
#define WAKE_UP_INT_BIT             0x1000
#define EXT_INT                     0x0800
#define LOW_BAT_INT_BIT             0x0400
#define FIFO_EMPTY_BIT              0x0200
#define DRSSI_BIT                   0x0100
#define DATA_QUALITY_BIT            0x0080
#define CLOCK_RECOVER_BIT           0x0040
#define AFC_TOGGELING_BIT           0x0020
#define LATCH_BITS                  (FIFO_FULL_BIT|POR_BIT|FIFO_OVER_FLOW_BIT|WAKE_UP_INT_BIT|EXT_INT|LOW_BAT_INT_BIT)


#define LOW_BATTERIE_COMMAND        0xC000
#define LOW_BATTERIE_RESET          0xC000
#define CLOCK_FREQU_10_MHZ          0x00E0

#define CRYSTAL_CAPACITY_PF(x) ((((unsigned short)(((x)-8.5)*2.0)))&0x000F)

#define CENTRE_FREQ_433MHZ(f0) (((unsigned short)(((((float)(f0))/(10.0*1.0))-43.0)*4000.0))&0x0FFF)
#define CENTRE_FREQ_868MHZ(f0) (((unsigned short)(((((float)(f0))/(10.0*2.0))-43.0)*4000.0))&0x0FFF)
#define CENTRE_FREQ_915MHZ(f0) (((unsigned short)(((((float)(f0))/(10.0*3.0))-30.0)*4000.0))&0x0FFF)

#define BAUDRATE(br) (((10000000UL/((unsigned long)(br)*29UL))-1)&0x007F)

#define RSSI_DBM(x) (((((x)+103)/6))&0x0007)

#define DATA_QUALITY(x) ((x)&0x0007)

#define FIFO_SIZE(x) (((x)&0x0F)<<4)

#define BANDWIDTH_KHZ(x)       (((((x)-15)/15)<<4)&0x00F0)
#define OUTPUTPOWERREDUCTION(x) (((x)/3)&0x0007)


volatile unsigned int delaytimer;
volatile unsigned int sekundenzaehler;
unsigned int sekundenalt;
unsigned int timer;

/**
Verzoegerungsfunktion durch Abwarten bis Interrupt den delaytimer auf 0 heruntergezaehlt hat
*/
void delay(unsigned int d) {
  delaytimer = d;
  while (delaytimer) {
  }
}

unsigned int rfm12_spi(unsigned int datenout) {
  unsigned int i;
  unsigned int datenin;

  datenin = 0;
  CS_LOW;
  for (i=0; i<16; i++) {
    if ((datenout & (unsigned int)0x8000)==0) {
      MSO_LOW;
    }
    else {
      MSO_HIGH;
    }
    SCL_HIGH;
    datenin = datenin << 1;
    if (MSI_IS_HIGH) {
      datenin = datenin | 0x0001;
    }
    SCL_LOW;
    datenout = datenout << 1;
  }
  CS_HIGH;
  return(datenin);
}


void rfm12_init() {
  rfm12_spi(STATUS_COMMAND);
  rfm12_spi(DEFAULT_CONFIG_VAL|ENABLE_INTERNAL_DATAREG);
  rfm12_spi(DEFAULT_POWER_MAN_VAL);
  rfm12_spi(FREQUENCY_COMMAND|CENTRE_FREQ_433MHZ(FUNKFREQUENZ));
  rfm12_spi(BAUD_RATE_COMMAND|BAUDRATE(2400));
  rfm12_spi(DEFAULT_RECEIVER_CONTROL_VAL);
  rfm12_spi(DATA_FILTER_COMMAND|CLOCK_RECOVERY_AUTO|DATA_QUALITY(4));
  rfm12_spi(DEFAULT_FIFO_VAL);
  rfm12_spi(SYNC_PATTERN_RESET);
  rfm12_spi(AFC_COMMAND | AFC_ENABLE | AFC_OFFSET_ENABLE | AFC_NO_LIMIT | AFC_IF_VDI);
  rfm12_spi(TRANSMITTER_CONTROL_COMMAND|BANDWIDTH_KHZ(90)|OUTPUTPOWERREDUCTION(0));
  rfm12_spi(DEFAULT_WAKEUP);
  rfm12_spi(DEFAULT_LOW_DUTY_CYCLE);
  rfm12_spi(LOW_BATTERIE_RESET);
}

void rfm12_send(unsigned char datenout) {
  
  while (INT_IS_HIGH) {
  }
  rfm12_spi(TRANSMITTER_WRITE_COMMAND + datenout);
}

void rfm12_send_kennung(unsigned char datenout) {
  rfm12_spi(STATUS_COMMAND);
  rfm12_spi(DEFAULT_POWER_MAN_VAL);
  //      rfm12_send(0xAA);
  rfm12_send(0xAA);
  rfm12_send(0xAA);
  rfm12_send(0x2D);
  rfm12_send(0xD4);
  rfm12_send(datenout);
  rfm12_send(datenout);
  rfm12_send(datenout);
  rfm12_send(0xAA);
  rfm12_send(0xAA);
  rfm12_send(0xAA);
  rfm12_spi(POWER_MAN_COMMAND | DISABLE_CLOCK_PIN);
}


interrupt (TIMERA1_VECTOR) timera1_interrupt(void)
{
  switch (TAIV) {
    /* Nur bei Ueberlauf von TACCR1 */
  case 2:
    eint(); /* Interrupts wieder zulassen, damit TIMERA0 weiterhin drankommen kann. */
    TACCR1 += PERIODEPWM; /* Neuen Zaehlervergleichswert speichern */
    timer++;
    if (timer >= FREQPWM) {
      timer = 0;
      sekundenzaehler++;
    }
    /* Fuers kurzzeitge Warten gibt es noch den delaytimer, der in diesem Interrupt runtergezaehlt wird */
    if (delaytimer) {
      delaytimer--;
    }
    break;
  case 4:
    break;
  case 10:
    break;
  default:
    ;
  }
}

/********************************************************************/
int main(void) {
  unsigned char z;

  WDTCTL = WDTCTL_INIT;               /*Init watchdog timer */

  P1OUT  = P1OUT_INIT;              /* Init output data of port1*/
  P2OUT  = P2OUT_INIT;              /* Init output data of port2*/

  P1SEL  = P1SEL_INIT;              /*Select port or module -function on port1 */
  P2SEL  = P2SEL_INIT;      /*Select port or module -function on port2 */

  P1DIR  = P1DIR_INIT;                /* Init port direction register of port1*/
  P2DIR  = P2DIR_INIT;                /*Init port direction register of port2*/

  P1REN  = P1REN_INIT;
  P2REN  = P2REN_INIT;

  P1IES  = P1IES_INIT;                /*init port interrupts*/
  P2IES  = P2IES_INIT;
  P1IE   = P1IE_INIT;
  P2IE   = P2IE_INIT;

  DCOCTL = CALDCO_8MHZ;
  BCSCTL1 = XT2OFF | CALBC1_8MHZ;
  BCSCTL2 = DIVS0 | DIVS1;

  /* SMCLK; Div = 2; Continuous mode */
  TACTL = TASSEL_SMCLK | ID_DIV2 | MC_CONT;
  TACCR0 = 0xffff;
  TACCR1 = PERIODEPWM;

  /* Kein Capture; GND Input; Async Capture; Compare mode; OUT set mode; high out */
  TACCTL0 = CM_DISABLE | CCIS_GND | SCS_ASYNC | CAP_COMP | OUTMOD_OUT | OUT_LOW;
  TACCTL1 = CM_DISABLE | CCIS_GND | SCS_ASYNC | CAP_COMP | OUTMOD_TOGGLE | CCIE | OUT_LOW;

  sekundenzaehler = 0;
  timer = 0;
  
  eint();
  while(sekundenzaehler < 1) {
  }
  rfm12_init();
  z = 0;
  while (z < STARTBURST) {
    if (sekundenalt != sekundenzaehler) {
      rfm12_send_kennung('1');
      sekundenalt = sekundenzaehler;
      TOGGLE_LED;
      delay(30);
      TOGGLE_LED;
      z++;
    }
  }
  while (1) {
    if (sekundenalt + SENDEPERIODE < sekundenzaehler) {
      rfm12_send_kennung('1');
      sekundenalt = sekundenzaehler;
      TOGGLE_LED;
      delay(30);
      TOGGLE_LED;
    }
  }
}
