#ifndef HARDWARE_H
#define HARDWARE_H

#include <io.h>
#include <signal.h>
#include <iomacros.h>

/* Pinbelegung */
/* Pin1:  VCC MSP430F20x1
   Pin2:  P1.0/TACLK/ACLK/CA0:    Input, int. Pullup, Taste gegen GND
   Pin3:  P1.1/TA0/CA1:           Input, int. Pullup, Taste gegen GND
   Pin4:  P1.2/TA1/CA2:           Input, int. Pullup, Taste gegen GND
   Pin5:  P1.3/CAOUT/CA3:         Input, int. Pullup, Stecker gegen GND
   Pin6:  P1.4/SMCLK/CA4/TCK:     Input, IR-Empfaenger mit 30k Pullup intern
   Pin7:  P1.5/TA0/CA5/TMS:       Output Power fuer IR-Empfaenger
   
   Pin8:  P1.6/TA1/CA6/TDI/TCLK:  Input, Komparatoreingang CA6, Spannungsteiler von P2.7 gegen GND
   Pin9:  P1.7/CAOUT/CA7/TDO/TDI: Input, int. Pullup, NC
   Pin10: RESET/NMI/SBWTDIO:      RC fuer Reset
   Pin11: TEST/SBWTCK:            Pulldown
   Pin12: P2.7/XOUT:              Output, Indikator-LED, High Aktiv
   Pin13: P2.6/XIN/TA1:           Output, IR-LED, High Aktiv ueber Stromquelle
   Pin14: GND */

#define WDTCTL_INIT     WDTPW|WDTHOLD

#define ABZUG 0x1
#define MAGAZINAUSWURF 0x2
#define MAGAZINEINSCHUB 0x4
#define EINSTELLUNG 0x8
#define DREI_TASTEN (ABZUG | MAGAZINAUSWURF | MAGAZINEINSCHUB)
#define ALLE_TASTEN ((DREI_TASTEN) | EINSTELLUNG)

#define ABZUG_GEDRUECKT ((P1IN & ABZUG) == 0)
#define AUSWURF_GEDRUECKT ((P1IN & MAGAZINAUSWURF) == 0)
#define EINSCHUB_GEDRUECKT ((P1IN & MAGAZINEINSCHUB) == 0)
#define EINSTELLUNG_GESTECKT ((P1IN & EINSTELLUNG) == 0)
#define KEINE_TASTE_GEDRUECKT ((P1IN & ALLE_TASTEN) == ALLE_TASTEN)

#define LED 0x80
#define LED_AN P2OUT = P2OUT | LED
#define LED_AUS P2OUT = P2OUT & ~LED
#define LED_TOGGLE P2OUT = P2OUT ^ LED

#define IR_LED 0x40
#define NN1_7 0x80

#define IR_PORT 0x10
#define IR_ERKANNT ((P1IN & IR_PORT) == 0)

#define IR_POWER 0x20
#define IR_POWER_ON P1OUT = P1OUT | IR_POWER
#define IR_POWER_OFF P1OUT = P1OUT & ~IR_POWER
#define IR_POWER_TOGGLE P1OUT = P1OUT ^ IR_POWER

//Port Output Register 'P1OUT, P2OUT':
#define P1OUT_INIT      0xFF                       // Init Output data of port1
#define P2OUT_INIT      0x00                       // Init Output data of port2

//Port Direction Register 'P1DIR, P2DIR':
#define P1DIR_INIT      IR_POWER                     // Init of Port1 Data-Direction Reg (Out=1 / Inp=0)
#define P2DIR_INIT      LED | IR_LED                 // Init of Port2 Data-Direction Reg (Out=1 / Inp=0)

//Selection of Port or Module -Function on the Pins 'P1SEL, P2SEL'
#define P1SEL_INIT      0x00                    // P1-Modules: (IO=0 / Periph=1)
#define P2SEL_INIT      IR_LED                    // P2-Modules: (IO=0 / Periph=1)

#define P1REN_INIT      ALLE_TASTEN | EINSTELLUNG | NN1_7

//Interrupt capabilities of P1 and P2
#define P1IE_INIT       0x0F                    // Interrupt Enable (0=dis 1=enabled)
#define P2IE_INIT       0                       // Interrupt Enable (0=dis 1=enabled)
#define P1IES_INIT      0x1F                    // Interrupt Edge Select (0=pos 1=neg)
#define P2IES_INIT      0                       // Interrupt Edge Select (0=pos 1=neg)

#endif //HARDWARE_H
