#ifndef HARDWARE_H
#define HARDWARE_H

#include <io.h>
#include <signal.h>
#include <iomacros.h>

/* Pinbelegung */
/* Pin1:  VCC MSP430F20x1
   Pin2:  P1.0/TACLK/ACLK/CA0:    Input, int. Pullup, IR-Empfaenger
   Pin3:  P1.1/TA0/CA1:           Input, int. Pullup, Taste gegen GND
   Pin4:  P1.2/TA1/CA2:           Output, DC-DC Wandler Ein-Aus
   Pin5:  P1.3/CAOUT/CA3:         Output, LED am Muetzenschirm
   Pin6:  P1.4/SMCLK/CA4/TCK:     Output, NC
   Pin7:  P1.5/TA0/CA5/TMS:       Output, NC
   
   Pin8:  P1.6/TA1/CA6/TDI/TCLK:  Output, NC
   Pin9:  P1.7/CAOUT/CA7/TDO/TDI: Output, NC
   Pin10: RESET/NMI/SBWTDIO:      RC fuer Reset
   Pin11: TEST/SBWTCK:            Pulldown
   Pin12: P2.7/XOUT:              Output, Rundum LEDs auf Muetze
   Pin13: P2.6/XIN/TA1:           Output, IR-LED am Muetzenschirm
   Pin14: GND */

//Port Output Register 'P1OUT, P2OUT':
#define P1OUT_INIT      0xF3                       // Init Output data of port1
#define P2OUT_INIT      0x00                       // Init Output data of port2

//Port Direction Register 'P1DIR, P2DIR':
#define P1DIR_INIT      0xFC                    // Init of Port1 Data-Direction Reg (Out=1 / Inp=0)
#define P2DIR_INIT      0xC0                    // Init of Port2 Data-Direction Reg (Out=1 / Inp=0)

//Selection of Port or Module -Function on the Pins 'P1SEL, P2SEL'
#define P1SEL_INIT      0x20                    // P1-Modules:
#define P2SEL_INIT      0x40                    // P2-Modules

#define P1REN_INIT      0x03

//Interrupt capabilities of P1 and P2
#define P1IE_INIT       0x02                    // Interrupt Enable (0=dis 1=enabled)
#define P2IE_INIT       0                       // Interrupt Enable (0=dis 1=enabled)
#define P1IES_INIT      0x03                    // Interrupt Edge Select (0=pos 1=neg)
#define P2IES_INIT      0                       // Interrupt Edge Select (0=pos 1=neg)

#define WDTCTL_INIT     WDTPW|WDTHOLD

#define LEDS 0x80
#define LEDS_AN P2OUT = P2OUT | LEDS
#define LEDS_AUS P2OUT = P2OUT & ~LEDS

#define POWER 0x4
#define VCC_5V_OFF P1OUT = P1OUT | POWER
#define VCC_5V_ON P1OUT = P1OUT & ~POWER

#define LED 0x08
#define LED_AN P1OUT = P1OUT | LED
#define LED_AUS P1OUT = P1OUT & ~LED

#define TASTE_PORT 0x2
#define TASTE_GEDRUECKT ((P1IN & TASTE_PORT) == 0)

#define IR_PORT 0x01
#define IR_ERKANNT ((P1IN & IR_PORT) == 0)
#define IR_PORT_DOWN P1OUT = P1OUT & ~IR_PORT
#define IR_PORT_UP P1OUT = P1OUT | IR_PORT

#endif //HARDWARE_H
